/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.duck.IMasterControllerProvider;
import com.yungnickyoung.minecraft.bettercaves.worldgen.BetterCavesWorldCarverConfig;
import com.yungnickyoung.minecraft.bettercaves.worldgen.context.CavegenContext;
import com.yungnickyoung.minecraft.bettercaves.worldgen.controller.MasterController;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2939;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_5873;
import net.minecraft.class_6350;
import net.minecraft.class_6643;
import net.minecraft.class_6880;

public class BetterCavesWorldCarver
extends class_2939<BetterCavesWorldCarverConfig> {
    public BetterCavesWorldCarver(Codec<BetterCavesWorldCarverConfig> codec) {
        super(codec);
    }

    @ParametersAreNonnullByDefault
    public boolean carve(class_5873 carvingContext, BetterCavesWorldCarverConfig config, class_2791 centerChunk, Function<class_2338, class_6880<class_1959>> biomeProvider, class_5819 random, class_6350 aquifer, class_1923 carvingChunkPos, class_6643 carvingMask) {
        CavegenContext context = CavegenContext.peek();
        if (context == null) {
            return false;
        }
        class_3218 serverLevel = context.getServerLevel();
        if (serverLevel == null) {
            BetterCavesCommon.LOGGER.error("Unable to retrieve ServerLevel from CarvingContext!");
            return false;
        }
        CavegenContext.pop();
        IMasterControllerProvider provider = (IMasterControllerProvider)serverLevel;
        MasterController masterController = provider.getMasterController();
        if (masterController == null) {
            BetterCavesCommon.LOGGER.info("CREATING AND INIT'ING MASTER CONTROLLER...");
            masterController = new MasterController(serverLevel, config);
            provider.setMasterController(masterController);
        }
        return masterController.carve(centerChunk, biomeProvider, carvingMask, aquifer);
    }

    @ParametersAreNonnullByDefault
    public boolean isStartChunk(BetterCavesWorldCarverConfig config, class_5819 random) {
        return true;
    }
}

